/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.strawgolem.entity;

import com.t2pellet.strawgolem.config.StrawgolemConfig;
import com.t2pellet.strawgolem.crop.CropHandler;
import com.t2pellet.strawgolem.crop.CropRegistry;
import com.t2pellet.strawgolem.entity.EntityStrawngGolem;
import com.t2pellet.strawgolem.entity.ai.GolemDeliverGoal;
import com.t2pellet.strawgolem.entity.ai.GolemFleeGoal;
import com.t2pellet.strawgolem.entity.ai.GolemHarvestGoal;
import com.t2pellet.strawgolem.entity.ai.GolemLookAtPlayerGoal;
import com.t2pellet.strawgolem.entity.ai.GolemLookRandomlyGoal;
import com.t2pellet.strawgolem.entity.ai.GolemPoutGoal;
import com.t2pellet.strawgolem.entity.ai.GolemTemptGoal;
import com.t2pellet.strawgolem.entity.ai.GolemTetherGoal;
import com.t2pellet.strawgolem.entity.ai.GolemWanderGoal;
import com.t2pellet.strawgolem.entity.capability.CapabilityHandler;
import com.t2pellet.strawgolem.entity.capability.hunger.Hunger;
import com.t2pellet.strawgolem.entity.capability.hunger.IHasHunger;
import com.t2pellet.strawgolem.entity.capability.lifespan.Lifespan;
import com.t2pellet.strawgolem.entity.capability.memory.Memory;
import com.t2pellet.strawgolem.entity.capability.tether.IHasTether;
import com.t2pellet.strawgolem.entity.capability.tether.Tether;
import com.t2pellet.strawgolem.events.WorldInteractHandler;
import com.t2pellet.strawgolem.network.HealthPacket;
import com.t2pellet.strawgolem.platform.Services;
import com.t2pellet.strawgolem.registry.CommonRegistry;
import java.util.Arrays;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1427;
import net.minecraft.class_1439;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2511;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4050;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;

public class EntityStrawGolem
extends class_1427
implements IHasHunger,
IHasTether {
    private static final class_2960 ResourceLocation = new class_2960("strawgolem", "strawgolem");
    private static final int maxLifespan = StrawgolemConfig.Health.getLifespan() + 12000;
    private static final int maxHunger = StrawgolemConfig.Health.getHunger() + 6000;
    private final Lifespan lifespan = CapabilityHandler.INSTANCE.get(Lifespan.class).orElseThrow(() -> new InstantiationError("Failed to create lifespan cap"));
    private final Memory memory = CapabilityHandler.INSTANCE.get(Memory.class).orElseThrow(() -> new InstantiationError("Failed to create memory cap"));
    private final class_1277 inventory;
    private final Tether tether = CapabilityHandler.INSTANCE.get(Tether.class).orElseThrow(() -> new InstantiationError("Failed to create tether cap"));
    private final Hunger hunger = CapabilityHandler.INSTANCE.get(Hunger.class).orElseThrow(() -> new InstantiationError("Failed to create new hunger cap"));
    private boolean tempted = false;
    public class_2338 harvestPos = null;

    public static class_5132.class_5133 createMob() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23719, 0.2);
    }

    public EntityStrawGolem(class_1299<? extends EntityStrawGolem> type, class_1937 levelIn) {
        super(type, levelIn);
        this.inventory = new class_1277(1);
    }

    protected void method_5959() {
        int priority = 0;
        this.field_6201.method_6277(++priority, (class_1352)new GolemPoutGoal(this));
        this.field_6201.method_6277(++priority, (class_1352)new GolemFleeGoal(this));
        this.field_6201.method_6277(++priority, (class_1352)new GolemTemptGoal(this));
        this.field_6201.method_6277(++priority, (class_1352)new GolemHarvestGoal(this));
        this.field_6201.method_6277(++priority, (class_1352)new GolemDeliverGoal(this));
        if (StrawgolemConfig.Tether.isTetherEnabled()) {
            this.field_6201.method_6277(++priority, new GolemTetherGoal<EntityStrawGolem>(this, 0.8));
        }
        this.field_6201.method_6277(++priority, (class_1352)new GolemWanderGoal(this));
        this.field_6201.method_6277(++priority, (class_1352)new GolemLookAtPlayerGoal(this, 4.0f));
        this.field_6201.method_6277(++priority, (class_1352)new GolemLookRandomlyGoal(this));
    }

    @SafeVarargs
    public final boolean isRunningGoal(Class<? extends class_1352> ... clazzes) {
        return this.field_6201.method_19048().anyMatch(goal -> Arrays.stream(clazzes).anyMatch(clazz -> clazz.isInstance(goal.method_19058())));
    }

    public void method_5670() {
        super.method_5670();
        if (!this.field_6002.field_9236) {
            this.lifespan.update();
            this.hunger.update();
            float healthCap = 8.0f * (float)Math.round((float)this.lifespan.get() / (float)StrawgolemConfig.Health.getLifespan());
            this.method_5996(class_5134.field_23716).method_6192((double)healthCap);
            if (this.method_6032() > healthCap) {
                this.method_6033(healthCap);
            }
            if (this.holdingFullBlock() && StrawgolemConfig.Health.isHeavyPenalty()) {
                this.lifespan.update();
                this.hunger.update();
            }
            if (this.method_5721() && !this.method_5799() && StrawgolemConfig.Health.isRainPenalty()) {
                this.lifespan.update();
            }
            if (this.method_5816() && StrawgolemConfig.Health.isWaterPenalty()) {
                this.lifespan.update();
            }
            if (this.field_5974.nextInt(40) == 0) {
                Services.PACKETS.sendInRange(new HealthPacket(this), (class_1297)this, 25.0f);
            }
            if (this.lifespan.isOver()) {
                this.method_5643(class_1282.field_5846, this.method_6063() * 100.0f);
            }
            if (StrawgolemConfig.Health.getHunger() > 0 && this.hunger.get() * 4 < StrawgolemConfig.Health.getHunger() && this.field_5974.nextInt(120) == 0) {
                this.method_5783(CommonRegistry.Sounds.GOLEM_STRAINED, 1.0f, 1.0f);
            }
        } else if (StrawgolemConfig.Health.getLifespan() > 0 && this.lifespan.get() * 4 < StrawgolemConfig.Health.getLifespan() && this.field_5974.nextInt(80) == 0) {
            this.field_6002.method_8406((class_2394)CommonRegistry.Particles.getFlyParticle(), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
        }
    }

    public boolean isInCold() {
        return ((class_1959)this.field_6002.method_23753(this.method_24515()).comp_349()).method_8712() < 0.15f;
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1792 heldItem = player.method_5998(hand).method_7909();
        if (heldItem == class_1802.field_8861) {
            int newLifespan = this.lifespan.get() + 12000;
            if (newLifespan > maxLifespan) {
                this.method_6033(this.method_6032() + 0.5f);
                return class_1269.field_5814;
            }
            if (!this.field_6002.method_8608()) {
                this.method_6033(this.method_6032() + 0.5f);
                if (StrawgolemConfig.Health.getLifespan() > -1) {
                    this.lifespan.set(newLifespan);
                }
                if (!player.method_7337()) {
                    player.method_5998(hand).method_7934(1);
                }
                Services.PACKETS.sendInRange(new HealthPacket(this), (class_1297)this, 25.0f);
                this.method_5783(CommonRegistry.Sounds.GOLEM_HEAL, 1.0f, 1.0f);
                this.method_5783(class_3417.field_14573, 1.0f, 1.0f);
            }
            this.spawnHealParticles(this.method_23317(), this.method_23318(), this.method_23321());
            return class_1269.field_21466;
        }
        if (heldItem == class_1802.field_8279) {
            int newHunger = this.hunger.get() + 6000;
            if (newHunger > maxHunger) {
                return class_1269.field_5814;
            }
            if (!this.field_6002.method_8608()) {
                this.hunger.set(newHunger);
                if (!player.method_7337()) {
                    player.method_5998(hand).method_7934(1);
                }
                Services.PACKETS.sendInRange(new HealthPacket(this), (class_1297)this, 25.0f);
                this.method_5783(CommonRegistry.Sounds.GOLEM_HEAL, 1.0f, 1.0f);
            }
            this.spawnHappyParticles(this.method_23317(), this.method_23318(), this.method_23321());
            return class_1269.field_21466;
        }
        if (heldItem == class_1802.field_8162) {
            if (hand == class_1268.field_5810 || !player.method_5715()) {
                return class_1269.field_5814;
            }
            if (!this.field_6002.method_8608()) {
                WorldInteractHandler.addMapping(player.method_5667(), this.method_5628());
                class_2588 message = new class_2588("strawgolem.order", new Object[]{this.method_5476().getString()});
                player.method_7353((class_2561)message, true);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    private void spawnHealParticles(double x, double y, double z) {
        this.field_6002.method_8406((class_2394)class_2398.field_11201, x + this.field_5974.nextDouble() - 0.5, y + 0.4, z + this.field_5974.nextDouble() - 0.5, this.method_18798().field_1352, this.method_18798().field_1351, this.method_18798().field_1350);
    }

    private void spawnHappyParticles(double x, double y, double z) {
        this.field_6002.method_8406((class_2394)class_2398.field_11211, x + this.field_5974.nextDouble() - 0.5, y + 0.4, z + this.field_5974.nextDouble() - 0.5, this.method_18798().field_1352, this.method_18798().field_1351, this.method_18798().field_1350);
    }

    public void method_5800(class_3218 world, class_1538 bolt) {
        if (this.field_5974.nextInt(10) == 0 && !this.field_6002.method_8608()) {
            EntityStrawngGolem strawngGolem = (EntityStrawngGolem)CommonRegistry.Entities.getStrawngGolemType().method_5883(this.field_6002);
            if (this.method_16914()) {
                strawngGolem.method_5665(this.method_5797());
            }
            strawngGolem.method_33574(this.method_19538());
            strawngGolem.method_5847(this.field_6241);
            strawngGolem.method_36457(this.method_36455());
            strawngGolem.method_5814(this.field_6038, this.field_5971, this.field_5989);
            this.method_5650(class_1297.class_5529.field_26999);
            if (this.field_6002.method_8320(this.method_24515()).method_26204() == class_2246.field_10036) {
                this.field_6002.method_8501(this.method_24515(), class_2246.field_10124.method_9564());
            }
            this.field_6002.method_8649((class_1297)strawngGolem);
        }
    }

    protected void method_6074(class_1282 source, float $$1) {
        super.method_6074(source, $$1);
        if (source.method_5526() instanceof class_1657 && !this.isRunningGoal(GolemHarvestGoal.class, GolemDeliverGoal.class, GolemFleeGoal.class, GolemTemptGoal.class, GolemPoutGoal.class, GolemTetherGoal.class)) {
            int maxRange = StrawgolemConfig.Harvest.getSearchRange();
            for (int i = -maxRange; i < maxRange; ++i) {
                for (int j = -maxRange; j < maxRange; ++j) {
                    for (int k = -maxRange; k < maxRange; ++k) {
                        class_2338 currPos = this.method_24515().method_10069(i, j, k);
                        if (!CropRegistry.INSTANCE.isGrownCrop(this.field_6002.method_8320(currPos))) continue;
                        CropHandler.INSTANCE.addCrop(this.field_6002, currPos);
                    }
                }
            }
        }
    }

    public boolean method_5974(double $$0) {
        return false;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source == class_1282.field_16992) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    public boolean method_5757() {
        if (this.field_5960) {
            return false;
        }
        float scaledWidth = this.method_18377((class_4050)class_4050.field_18076).field_18067 * 0.8f;
        class_238 headBounds = class_238.method_30048((class_243)this.method_33571(), (double)scaledWidth, (double)1.0E-6, (double)scaledWidth);
        return class_2338.method_29715((class_238)headBounds).anyMatch(pos -> {
            class_2680 state = this.field_6002.method_8320(pos);
            return !state.method_26215() && state.method_26228((class_1922)this.field_6002, pos) && class_259.method_1074((class_265)state.method_26220((class_1922)this.field_6002, pos).method_1096((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()), (class_265)class_259.method_1078((class_238)headBounds), (class_247)class_247.field_16896) && !(state.method_26204() instanceof class_2511);
        });
    }

    protected void method_6099(class_1282 source, int lootingMultiplier, boolean allowDrops) {
        super.method_6099(source, lootingMultiplier, allowDrops);
        if (!this.field_6002.method_8608()) {
            this.field_6002.method_8649((class_1297)new class_1542(this.field_6002, this.method_23317(), this.method_23318(), this.method_23321(), this.inventory.method_5438(0).method_7972()));
        }
    }

    public boolean canReachBlock(class_4538 levelIn, class_2338 pos) {
        class_243 blockPos;
        if (levelIn != this.field_6002) {
            return false;
        }
        if ((double)pos.method_19455((class_2382)pos) > 1.27 * (double)StrawgolemConfig.Harvest.getSearchRange()) {
            return false;
        }
        class_243 eyePos = class_243.method_24953((class_2382)this.method_24515()).method_1031(0.0, 0.5, 0.0);
        class_3965 result = this.field_6002.method_17742(new class_3959(eyePos, blockPos = class_243.method_24953((class_2382)pos), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
        return result.method_17783() == class_239.class_240.field_1333 || result.method_17777().method_19771((class_2382)pos, 1.0);
    }

    public boolean isHarvesting() {
        return this.harvestPos != null;
    }

    public class_1277 getInventory() {
        return this.inventory;
    }

    public boolean isHandEmpty() {
        return this.method_6047().method_7960();
    }

    public class_1799 method_6118(class_1304 slot) {
        if (slot == class_1304.field_6173) {
            return this.inventory.method_5438(0);
        }
        return class_1799.field_8037;
    }

    public boolean holdingFullBlock() {
        class_1799 item = this.method_6047();
        class_1792 class_17922 = item.method_7909();
        if (!(class_17922 instanceof class_1747)) {
            return false;
        }
        class_1747 blockItem = (class_1747)class_17922;
        return blockItem != class_1802.field_8162 && blockItem.method_7711().method_9564().method_26225() && blockItem.method_7711().method_8389() == blockItem;
    }

    public Lifespan getLifespan() {
        return this.lifespan;
    }

    public Memory getMemory() {
        return this.memory;
    }

    @Override
    public Tether getTether() {
        return this.tether;
    }

    @Override
    public Hunger getHunger() {
        return this.hunger;
    }

    @Override
    public void setTempted(boolean tempted) {
        this.tempted = tempted;
    }

    @Override
    public boolean isTempted() {
        return this.tempted;
    }

    public void method_5814(double posX, double posY, double posZ) {
        if (this.method_5854() instanceof class_1439 || this.method_5854() instanceof EntityStrawngGolem) {
            class_1427 golemEntity = (class_1427)this.method_5854();
            double lookX = golemEntity.method_5720().field_1352;
            double lookZ = golemEntity.method_5720().field_1350;
            double magnitude = Math.sqrt(lookX * lookX + lookZ * lookZ);
            super.method_5814(posX + 1.71 * (lookX /= magnitude), posY - 0.55, posZ + 1.71 * (lookZ /= magnitude));
        } else {
            super.method_5814(posX, posY, posZ);
        }
    }

    public void method_5848() {
        super.method_5848();
        if (this.method_5854() instanceof class_1439 || this.method_5854() instanceof EntityStrawngGolem) {
            class_1309 ridingEntity = (class_1309)this.method_5854();
            double lookX = ridingEntity.method_5720().field_1352;
            double lookZ = ridingEntity.method_5720().field_1350;
            double magnitude = Math.sqrt(lookX * lookX + lookZ * lookZ);
            super.method_5814(this.method_23317() + (lookX /= magnitude), this.method_23318(), this.method_23321() + (lookZ /= magnitude));
        }
    }

    public void method_5652(class_2487 tag) {
        tag.method_10566("lifespan", this.lifespan.writeTag());
        tag.method_10566("hunger", this.hunger.writeTag());
        tag.method_10566("memory", this.memory.writeTag());
        tag.method_10566("inventory", (class_2520)this.inventory.method_7660());
        tag.method_10566("tether", this.tether.writeTag());
        if (this.harvestPos != null) {
            tag.method_10566("harvestPos", (class_2520)class_2512.method_10692((class_2338)this.harvestPos));
        }
        super.method_5652(tag);
    }

    public void method_5749(class_2487 tag) {
        if (tag.method_10545("lifespan")) {
            this.lifespan.readTag(tag.method_10580("lifespan"));
        }
        if (tag.method_10545("hunger")) {
            this.hunger.readTag(tag.method_10580("hunger"));
        }
        if (tag.method_10545("memory")) {
            this.memory.readTag(tag.method_10580("memory"));
        }
        if (tag.method_10545("inventory")) {
            this.inventory.method_7659((class_2499)tag.method_10580("inventory"));
        }
        if (tag.method_10545("tether")) {
            this.tether.readTag(tag.method_10580("tether"));
        }
        if (tag.method_10545("harvestPos")) {
            this.harvestPos = class_2512.method_10691((class_2487)((class_2487)tag.method_10580("harvestPos")));
        }
        super.method_5749(tag);
    }

    protected class_3414 method_5994() {
        if (StrawgolemConfig.Miscellaneous.isSoundsEnabled()) {
            if (this.field_6201.method_19048().anyMatch(goal -> goal.method_19058() instanceof GolemFleeGoal || goal.method_19058() instanceof GolemTetherGoal)) {
                return CommonRegistry.Sounds.GOLEM_SCARED;
            }
            if (this.holdingFullBlock()) {
                return CommonRegistry.Sounds.GOLEM_STRAINED;
            }
            return CommonRegistry.Sounds.GOLEM_AMBIENT;
        }
        return null;
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return StrawgolemConfig.Miscellaneous.isSoundsEnabled() ? CommonRegistry.Sounds.GOLEM_HURT : null;
    }

    protected class_3414 method_6002() {
        return StrawgolemConfig.Miscellaneous.isSoundsEnabled() ? CommonRegistry.Sounds.GOLEM_DEATH : null;
    }

    public int method_5970() {
        return this.holdingFullBlock() ? 60 : 120;
    }

    protected class_2960 method_5991() {
        return ResourceLocation;
    }
}

